/*
 * Decompiled with CFR 0.152.
 */
package nightmare2;

import Model.Target_File;
import Model.Util;
import java.awt.Dimension;
import java.io.File;
import java.io.FileWriter;
import java.util.Scanner;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import nightmare2.AboutBox;
import nightmare2.App;
import nightmare2.Common_Dialogs;
import nightmare2.ModuleFrame;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;

public class View
extends FrameView {
    private App app;
    private JMenuBar menuBar;
    private JMenuItem saveMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem closeMenuItem;
    private JMenuItem findMenuItem;
    private JMenuItem allocateMenuItem;
    private JMenuItem aboutMenuItem;
    private JPanel mainPanel;
    private JButton openButton;
    private JButton selectButton;
    private JButton quitButton;
    private JCheckBox endiannessCheckbox;
    private JDialog aboutBox;
    private static String oldINIpath = null;

    public View(App app) {
        super(app);
        this.app = app;
        this.initComponents();
        this.getFrame().setResizable(false);
    }

    private void unload() {
        Target_File.closeFile();
        ModuleFrame.resetOpenModules();
        this.endiannessCheckbox.setEnabled(true);
        this.openButton.setEnabled(false);
        this.saveMenuItem.setEnabled(false);
        this.saveAsMenuItem.setEnabled(false);
        this.closeMenuItem.setEnabled(false);
        this.allocateMenuItem.setEnabled(false);
        this.findMenuItem.setEnabled(false);
    }

    private void load() {
        this.endiannessCheckbox.setEnabled(false);
        this.openButton.setEnabled(true);
        this.saveMenuItem.setEnabled(true);
        this.saveAsMenuItem.setEnabled(true);
        this.closeMenuItem.setEnabled(true);
        this.allocateMenuItem.setEnabled(true);
        this.findMenuItem.setEnabled(true);
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = App.getApplication().getMainFrame();
            this.aboutBox = new AboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        App.getApplication().show(this.aboutBox);
    }

    private void openModule() {
        ModuleFrame.openModule();
    }

    @Action
    public void openButtonExecute() {
        if (!this.openButton.isEnabled()) {
            return;
        }
        try {
            this.openModule();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processINI(Scanner iniScanner) {
        String loadedString = iniScanner.nextLine();
        if (loadedString.equals("[Basis]")) {
            oldINIpath = null;
        } else {
            ModuleFrame.addModule(new File(loadedString), false);
        }
        while (iniScanner.hasNext()) {
            ModuleFrame.addModule(new File(iniScanner.nextLine()), false);
        }
        iniScanner.close();
    }

    private void selectFile() {
        if (!Target_File.isSaved() && Target_File.isOpen()) {
            if (Common_Dialogs.showYesNoDialog("Close the file?") != 0) {
                return;
            }
            try {
                Target_File.save(Common_Dialogs.showSaveFileDialog("file"));
                if (Target_File.isSaved()) {
                    this.writeINIfile();
                }
            }
            catch (Exception e) {
                Common_Dialogs.showCatchErrorDialog(e);
            }
        }
        this.unload();
        String path = App.getInitialPath();
        File toOpen = path != null ? new File(path) : Common_Dialogs.showOpenFileDialog("file");
        if (toOpen == null) {
            return;
        }
        Target_File.open(toOpen);
        if (Target_File.isOpen()) {
            this.load();
            App.setInitialPath(null);
            if (this.endiannessCheckbox.isSelected()) {
                Target_File.setBigEndian();
            } else {
                Target_File.setLittleEndian();
            }
            Scanner iniScanner = null;
            try {
                oldINIpath = Target_File.iniPath();
                iniScanner = new Scanner(new File(oldINIpath));
                this.processINI(iniScanner);
                try {
                    iniScanner.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                ModuleFrame.start();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Action
    public void selectButtonExecute() {
        if (!this.selectButton.isEnabled()) {
            return;
        }
        try {
            this.selectFile();
        }
        catch (Exception e) {
            Common_Dialogs.showCatchErrorDialog(e);
        }
    }

    private void writeINIfile() {
        File[] openModules;
        FileWriter iniFile;
        Scanner oldINIfile = null;
        if (oldINIpath != null) {
            try {
                new File(oldINIpath).delete();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        oldINIpath = Target_File.iniPath();
        boolean write = true;
        try {
            oldINIfile = new Scanner(new File(oldINIpath));
            if (oldINIfile != null && oldINIfile.nextLine().equals("[Basis]")) {
                write = false;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            oldINIfile.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!write) {
            return;
        }
        try {
            iniFile = new FileWriter(new File(oldINIpath));
        }
        catch (Exception e) {
            return;
        }
        for (File currFile : openModules = ModuleFrame.getOpenModules()) {
            try {
                iniFile.write(currFile.getPath() + Util.newline());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            iniFile.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void save(boolean saveAs) {
        try {
            if (!Target_File.isNamed() || saveAs) {
                Target_File.save(Common_Dialogs.showSaveFileDialog("file"));
            } else {
                Target_File.save(new File(Target_File.fileName()));
            }
            if (Target_File.isSaved()) {
                this.writeINIfile();
            }
        }
        catch (Exception e) {
            Common_Dialogs.showCatchErrorDialog(e);
        }
    }

    @Action
    public void saveMenuItemExecute() {
        if (!this.saveMenuItem.isEnabled()) {
            return;
        }
        try {
            this.save(false);
        }
        catch (Exception e) {
            Common_Dialogs.showCatchErrorDialog(e);
        }
    }

    @Action
    public void saveAsMenuItemExecute() {
        if (!this.saveAsMenuItem.isEnabled()) {
            return;
        }
        try {
            this.save(true);
        }
        catch (Exception e) {
            Common_Dialogs.showCatchErrorDialog(e);
        }
    }

    private void close() {
        if (JOptionPane.showConfirmDialog(null, "Are you sure you want to close the file?", "Confirm", 0) == 0) {
            if (!Target_File.isSaved()) {
                Target_File.save(Common_Dialogs.showSaveFileDialog("file"));
            }
            if (Target_File.isSaved()) {
                this.writeINIfile();
            }
            this.unload();
        }
    }

    @Action
    public void closeMenuItemExecute() {
        if (!this.closeMenuItem.isEnabled()) {
            return;
        }
        try {
            this.close();
        }
        catch (Exception e) {
            Common_Dialogs.showCatchErrorDialog(e);
        }
    }

    public void allocate() throws Exception {
        String result = JOptionPane.showInputDialog(null, "Enter the numer of bytes to allocate:", 0);
        int memToAllocate = Util.parseInt(result);
        int megabyte = 0x100000;
        if (memToAllocate > 0x100000) {
            throw new IllegalArgumentException("Can't allocate more than a megabyte at a time.");
        }
        int addressToReport = Target_File.size();
        memToAllocate = Target_File.expand(memToAllocate);
        Common_Dialogs.showGenericInformationDialog(String.format("0x%08X", memToAllocate) + " bytes allocated to " + String.format("0x%08X", addressToReport));
    }

    @Action
    public void allocateMenuItemExecute() {
        if (!this.allocateMenuItem.isEnabled() || !Target_File.isOpen()) {
            return;
        }
        try {
            this.allocate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void find() throws Exception {
        String result = JOptionPane.showInputDialog(null, "Enter value of the byte to search for strings of:", 0);
        byte byteToFind = (byte)Util.parseInt(result);
        result = JOptionPane.showInputDialog(null, "Enter the number of bytes needed:", 0);
        int memToFind = Util.parseInt(result);
        int resultAddress = Util.findByteString(Target_File.getData(), byteToFind, memToFind);
        if (resultAddress == -1) {
            Common_Dialogs.showGenericErrorDialog("The string was not found.");
        } else {
            Common_Dialogs.showGenericInformationDialog("String found at " + String.format("0x%08X", resultAddress));
        }
    }

    @Action
    public void findMenuItemExecute() {
        if (!this.findMenuItem.isEnabled()) {
            return;
        }
        try {
            this.find();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JMenu createMenu(ResourceMap resourceMap, String name, char mnemonic, JMenuItem[] items) {
        JMenu menu = new JMenu();
        menu.setMnemonic(mnemonic);
        menu.setText(resourceMap.getString(name + ".text", new Object[0]));
        menu.setName(name);
        for (JMenuItem item : items) {
            menu.add(item);
        }
        return menu;
    }

    private JMenuItem createMenuItem(ActionMap actionMap, ResourceMap resourceMap, String name, KeyStroke accelerator, Integer mnemonic, boolean enabled) {
        JMenuItem item = new JMenuItem();
        item.setAction(actionMap.get(name + "Execute"));
        if (accelerator != null) {
            item.setAccelerator(accelerator);
        }
        if (mnemonic != null) {
            item.setMnemonic(mnemonic);
        }
        item.setText(resourceMap.getString(name + ".text", new Object[0]));
        item.setToolTipText(resourceMap.getString(name + ".toolTipText", new Object[0]));
        item.setName(name);
        item.setEnabled(enabled);
        return item;
    }

    private JButton createButton(ActionMap actionMap, ResourceMap resourceMap, String name, boolean tooltip, boolean enabled) {
        JButton button = new JButton();
        button.setAction(actionMap.get(name + "Execute"));
        button.setText(resourceMap.getString(name + ".text", new Object[0]));
        button.setName(name);
        if (tooltip) {
            button.setToolTipText(resourceMap.getString(name + ".toolTipTest", new Object[0]));
        }
        button.setEnabled(enabled);
        return button;
    }

    private JCheckBox createCheckBox(ResourceMap resourceMap, String name, Integer mnemonic, boolean tooltip, boolean enabled) {
        JCheckBox checkbox = new JCheckBox();
        if (mnemonic != null) {
            checkbox.setMnemonic(mnemonic);
        }
        checkbox.setText(resourceMap.getString(name + ".text", new Object[0]));
        checkbox.setName(name);
        if (tooltip) {
            checkbox.setToolTipText(resourceMap.getString(name + ".toolTipText", new Object[0]));
        }
        checkbox.setEnabled(enabled);
        return checkbox;
    }

    private KeyStroke controlKeyStroke(int key) {
        return KeyStroke.getKeyStroke(key, 2);
    }

    private void initComponents() {
        ApplicationActionMap actionMap = Application.getInstance(App.class).getContext().getActionMap(View.class, this);
        ResourceMap resourceMap = Application.getInstance(App.class).getContext().getResourceMap(View.class);
        this.saveMenuItem = this.createMenuItem(actionMap, resourceMap, "saveMenuItem", this.controlKeyStroke(83), null, false);
        this.saveAsMenuItem = this.createMenuItem(actionMap, resourceMap, "saveAsMenuItem", null, 83, false);
        this.closeMenuItem = this.createMenuItem(actionMap, resourceMap, "closeMenuItem", this.controlKeyStroke(87), 67, false);
        this.allocateMenuItem = this.createMenuItem(actionMap, resourceMap, "allocateMenuItem", null, 65, false);
        this.findMenuItem = this.createMenuItem(actionMap, resourceMap, "findMenuItem", this.controlKeyStroke(70), 70, false);
        this.aboutMenuItem = new JMenuItem();
        this.aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        this.aboutMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 1));
        this.aboutMenuItem.setName("aboutMenuItem");
        this.menuBar = this.menuBar = new JMenuBar();
        this.menuBar.setName("menuBar");
        for (JMenu menu : new JMenu[]{this.createMenu(resourceMap, "fileMenu", 'f', new JMenuItem[]{this.saveMenuItem, this.saveAsMenuItem, this.closeMenuItem}), this.createMenu(resourceMap, "toolsMenu", 't', new JMenuItem[]{this.findMenuItem, this.allocateMenuItem}), this.createMenu(resourceMap, "helpMenu", 'h', new JMenuItem[]{this.aboutMenuItem})}) {
            this.menuBar.add(menu);
        }
        this.menuBar.setName("menuBar");
        this.setMenuBar(this.menuBar);
        this.mainPanel = new JPanel();
        this.openButton = this.createButton(actionMap, resourceMap, "openButton", false, false);
        this.selectButton = this.createButton(actionMap, resourceMap, "selectButton", true, true);
        this.quitButton = new JButton();
        this.quitButton.setAction(actionMap.get("quit"));
        this.quitButton.setName("quitButton");
        this.endiannessCheckbox = this.createCheckBox(resourceMap, "endiannessCheckbox", 69, true, true);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(73, 73, 73).addComponent(this.quitButton)).addGroup(mainPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.endiannessCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.selectButton)).addGroup(mainPanelLayout.createSequentialGroup().addGap(52, 52, 52).addComponent(this.openButton))).addContainerGap(25, Short.MAX_VALUE)));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.endiannessCheckbox).addComponent(this.selectButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.openButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 13, Short.MAX_VALUE).addComponent(this.quitButton).addContainerGap()));
        this.mainPanel.setMaximumSize(null);
        this.mainPanel.setName("mainPanel");
        this.mainPanel.setPreferredSize(new Dimension(203, 114));
        this.setComponent(this.mainPanel);
    }
}

