/*
 * Decompiled with CFR 0.152.
 */
package nightmare2;

import Controls.DecimalList;
import Controls.DependentControl;
import Controls.HexEditor;
import Controls.HexField;
import Controls.HexList;
import Controls.HexNumberEditor;
import Controls.SignedEditor;
import Controls.StructLoader;
import Controls.TextField;
import Controls.UnsignedEditor;
import Model.Module;
import Model.Struct;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.LinkedList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nightmare2.Common_Dialogs;
import nightmare2.ModuleFrame;

public class StructPane
extends Box {
    protected ModuleFrame view;
    protected Module module;
    private JComponent headingPanel = new JPanel();
    protected JPanel dependentControlsPanel = new JPanel();
    protected JScrollPane dependentScrollPane;
    protected LinkedList<JLabel> entryComponentLabels = new LinkedList();
    protected int finalEntryIndex;
    protected int selectedIndex;
    protected LinkedList<Module.EntryComponent> componentList = new LinkedList();
    protected LinkedList<Component> componentLinkedList = new LinkedList();

    private String toolTip(Module.EntryComponent input) {
        String typeString;
        if (!this.selectionInBounds()) {
            return "";
        }
        int address = input.getAddress(this.selectedIndex);
        int amount = input.getNumBitsOffset();
        int bitOffset = amount % 8;
        String string = typeString = bitOffset == 0 ? "byte" : "bit";
        if (bitOffset == 0) {
            amount >>= 3;
        }
        if (amount != 1) {
            typeString = typeString + "s";
        }
        String toolTipString = String.format("0x%08X:%d (%s) - %d bit", address, bitOffset, "offset by " + amount + " " + typeString, input.getBitCount());
        if (input.getBitCount() != 1) {
            toolTipString = toolTipString + "s";
        }
        if (input.getEntryType() == Module.EntryType.NEHU || input.getEntryType() == Module.EntryType.NDHU || input.getEntryType() == Module.EntryType.HEXA || input.getEntryType() == Module.EntryType.STRUCT) {
            toolTipString = toolTipString + " (hex)";
        }
        if (this.selectedIndex == this.finalEntryIndex) {
            toolTipString = "";
        }
        return toolTipString;
    }

    private void updateToolTips() {
        LinkedList<Module.EntryComponent> tempList = new LinkedList<Module.EntryComponent>();
        for (JLabel currComponentLabel : this.entryComponentLabels) {
            Module.EntryComponent currEntryComponent = this.componentList.pollFirst();
            tempList.add(currEntryComponent);
            String toolTipString = this.toolTip(currEntryComponent);
            currComponentLabel.setToolTipText(toolTipString);
            currComponentLabel.setText("    " + currEntryComponent.getName() + "            ");
        }
        this.componentList = tempList;
    }

    private void addDependentControls() {
        this.dependentControlsPanel.setLayout(new BoxLayout(this.dependentControlsPanel, 3));
        LinkedList<Module.EntryComponent> tempList = new LinkedList<Module.EntryComponent>();
        boolean first = false;
        for (Component currComponent : this.componentLinkedList) {
            Module.EntryComponent currEntryComponent = this.componentList.pollFirst();
            tempList.add(currEntryComponent);
            JLabel currentComponentLabel = new JLabel("    " + currEntryComponent.getName() + "            ");
            JPanel currComponentPanel = new JPanel();
            currComponentPanel.setLayout(new BorderLayout());
            currComponentPanel.add((Component)currentComponentLabel, "West");
            this.entryComponentLabels.add(currentComponentLabel);
            if (!first) {
                JPanel spacePanel = new JPanel();
                spacePanel.setSize(currComponentPanel.getSize());
                this.dependentControlsPanel.add(spacePanel);
                first = true;
            }
            JPanel editPanel = new JPanel();
            editPanel.add(currComponent);
            currComponentPanel.add((Component)editPanel, "East");
            JLabel guideLabel = new JLabel();
            class AutoSizeLine
            extends LineBorder {
                private boolean visible;

                public AutoSizeLine(Color color) {
                    super(color);
                    this.visible = false;
                }

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    if (!this.visible) {
                        return;
                    }
                    Color oldColor = g.getColor();
                    g.setColor(this.lineColor);
                    g.drawRect(x, y + height / 2, width, 1);
                    g.setColor(oldColor);
                }

                public boolean isVisible() {
                    return this.visible;
                }

                public void setVisible(boolean b) {
                    this.visible = b;
                }
            }
            final AutoSizeLine line = new AutoSizeLine(Color.BLACK);
            guideLabel.setBorder(line);
            guideLabel.addMouseListener(new MouseListener(){
                {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    line.setVisible(true);
                    StructPane.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    line.setVisible(false);
                    StructPane.this.repaint();
                }
            });
            currComponentPanel.add((Component)guideLabel, "Center");
            this.dependentControlsPanel.add(currComponentPanel);
        }
        this.componentList = tempList;
        this.dependentScrollPane = new JScrollPane(this.dependentControlsPanel);
        this.add(this.dependentScrollPane);
    }

    private void createDependentControls() {
        this.componentList = this.module.getComponentList();
        for (Module.EntryComponent currComponent : this.componentList) {
            if (currComponent.getEntryType() == Module.EntryType.TEXT) {
                this.componentLinkedList.add(new TextField(this, this.module, currComponent));
                continue;
            }
            if (currComponent.getEntryType() == Module.EntryType.HEXA) {
                this.componentLinkedList.add(new HexField(this, this.module, currComponent));
                continue;
            }
            if (currComponent.getEntryType() == Module.EntryType.NEHU) {
                this.componentLinkedList.add(new HexEditor(this, this.module, currComponent));
                continue;
            }
            if (currComponent.getEntryType() == Module.EntryType.STRUCT) {
                this.componentLinkedList.add(new StructLoader(this, this.module, currComponent));
                continue;
            }
            if (currComponent.getEntryType() == Module.EntryType.NEDS) {
                this.componentLinkedList.add(new SignedEditor(this, this.module, currComponent));
                continue;
            }
            if (currComponent.getEntryType() == Module.EntryType.NEDU) {
                this.componentLinkedList.add(new UnsignedEditor(this, this.module, currComponent));
                continue;
            }
            if (currComponent.getEntryType() == Module.EntryType.NDDU) {
                this.componentLinkedList.add(new DecimalList(this, this.module, currComponent));
                continue;
            }
            if (currComponent.getEntryType() != Module.EntryType.NDHU) continue;
            this.componentLinkedList.add(new HexList(this, this.module, currComponent));
        }
        this.addDependentControls();
    }

    protected final void updateAllEntryComponents() {
        for (Component currControl : this.componentLinkedList) {
            try {
                ((DependentControl)((Object)currControl)).update();
            }
            catch (Exception e) {
                Common_Dialogs.showCatchErrorDialog(e);
            }
        }
        this.updateToolTips();
    }

    private void displayErrors() {
        String errorString = this.module.getErrors();
        if (errorString.equals("")) {
            return;
        }
        Common_Dialogs.showGenericErrorDialog(errorString);
    }

    public StructPane(ModuleFrame view, File input, Integer baseAddress) {
        super(3);
        this.view = view;
        this.selectedIndex = 0;
        this.finalEntryIndex = 1;
        boolean struct = baseAddress != null && this instanceof StructPane;
        try {
            this.module = struct ? new Struct(input, baseAddress) : new Module(input);
        }
        catch (Exception e) {
            Common_Dialogs.showCatchErrorDialog(e);
            throw new RuntimeException("module failed to load");
        }
        this.headingPanel.setLayout(new BoxLayout(this.headingPanel, 3));
        this.add(this.headingPanel);
        JPanel hardwareOffsetPanel = new JPanel();
        JLabel hardwareOffsetLabel = new JLabel("Hardware offset: ");
        SpinnerNumberModel hardwareOffsetModel = new SpinnerNumberModel(0, Integer.MIN_VALUE, Integer.MAX_VALUE, 1);
        final JSpinner hardwareOffsetSpinner = new JSpinner(hardwareOffsetModel);
        hardwareOffsetSpinner.setEditor(new HexNumberEditor(hardwareOffsetSpinner, 8));
        hardwareOffsetSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                StructPane.this.module.setHardwareOffset((Integer)hardwareOffsetSpinner.getValue());
            }
        });
        hardwareOffsetSpinner.setValue(this.module.getHardwareOffset());
        hardwareOffsetPanel.add(hardwareOffsetLabel);
        hardwareOffsetPanel.add(hardwareOffsetSpinner);
        this.add(hardwareOffsetPanel);
        this.createDependentControls();
        if (struct) {
            this.updateAllEntryComponents();
        }
        this.displayErrors();
    }

    public final void addToHeading(JComponent comp) {
        this.headingPanel.add(comp);
    }

    public final void update() {
        this.view.pack();
    }

    public final String getModuleName() {
        return this.module.getDescription();
    }

    public final int extraWidth() {
        return this.dependentScrollPane.getVerticalScrollBar().getWidth();
    }

    public final int extraHeight() {
        return this.dependentScrollPane.getHorizontalScrollBar().getHeight();
    }

    public final boolean selectionInBounds() {
        return this.selectedIndex >= 0 && this.selectedIndex < this.finalEntryIndex;
    }

    public final int getSelectedIndex() {
        return this.selectedIndex;
    }
}

