/*
 * Decompiled with CFR 0.152.
 */
package nightmare2;

import Model.Util;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import java.util.Scanner;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import nightmare2.ModuleFrame;
import nightmare2.StructPane;

public class ModulePane
extends StructPane {
    private JPanel entryListPanel = new JPanel();
    private JComboBox entryListComboBox = new JComboBox();
    private JButton expandButton = new JButton("Expand");

    public ModulePane(ModuleFrame view, JComponent heading, File input) {
        super(view, input, null);
        this.addToHeading(heading);
        this.finalEntryIndex = 1;
        int entryCount = this.module.getEntryCount();
        LinkedList<String> entryNamesList = new LinkedList<String>();
        Scanner entryListScanner = null;
        try {
            entryListScanner = new Scanner(this.module.getEntryList());
        }
        catch (Exception e) {
            // empty catch block
        }
        while (entryListScanner != null && entryListScanner.hasNext()) {
            entryNamesList.add(entryListScanner.nextLine());
        }
        try {
            entryListScanner.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] entryNames = new String[entryNamesList.size()];
        int index = 0;
        for (String curr : entryNamesList) {
            entryNames[index++] = curr;
        }
        Util.renameDuplicates(entryNames);
        this.entryListComboBox.setEditable(false);
        for (int i = 0; i < entryCount; ++i) {
            if (i < entryNames.length) {
                this.entryListComboBox.addItem(entryNames[i]);
                continue;
            }
            this.entryListComboBox.addItem(String.format("0x%02X", i));
        }
        if (entryCount != 1) {
            this.entryListComboBox.addItem("--- Select an Entry ---");
            this.selectedIndex = this.finalEntryIndex = this.entryListComboBox.getItemCount() - 1;
            this.entryListComboBox.setSelectedIndex(this.finalEntryIndex);
        } else {
            this.selectedIndex = 0;
            this.finalEntryIndex = 1;
            this.entryListComboBox.setSelectedIndex(this.selectedIndex);
        }
        this.entryListComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModulePane.this.selectedIndex = ModulePane.this.entryListComboBox.getSelectedIndex();
                int count = ModulePane.this.entryListComboBox.getItemCount();
                if (ModulePane.this.selectedIndex != ModulePane.this.finalEntryIndex && count == ModulePane.this.finalEntryIndex + 1) {
                    int width = ((ModulePane)ModulePane.this).entryListComboBox.getSize().width;
                    ModulePane.this.entryListComboBox.removeItemAt(ModulePane.this.finalEntryIndex);
                    ModulePane.this.entryListComboBox.setMinimumSize(new Dimension(width, ((ModulePane)ModulePane.this).entryListComboBox.getSize().height));
                }
                ModulePane.this.updateAllEntryComponents();
            }
        });
        this.entryListPanel.add(this.entryListComboBox);
        this.expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModulePane.this.expandButton.setEnabled(false);
                int originalCount = ModulePane.this.module.getEntryCount();
                ModulePane.this.module.expand();
                int expandedCount = ModulePane.this.module.getEntryCount();
                ++ModulePane.this.selectedIndex;
                try {
                    ModulePane.this.entryListComboBox.removeItemAt(ModulePane.this.finalEntryIndex);
                }
                catch (Exception e) {
                    // empty catch block
                }
                for (int i = originalCount; i < expandedCount; ++i) {
                    ModulePane.this.entryListComboBox.addItem(String.format("0x%02X", i));
                }
                ModulePane.this.entryListComboBox.addItem("--- Select an Entry ---");
                ModulePane.this.finalEntryIndex = ModulePane.this.entryListComboBox.getItemCount() - 1;
                ModulePane.this.entryListComboBox.setSelectedIndex(ModulePane.this.finalEntryIndex);
                ModulePane.this.updateAllEntryComponents();
            }
        });
        if (!this.module.canExpand()) {
            this.expandButton.setEnabled(false);
        }
        this.entryListPanel.add(this.expandButton);
        this.addToHeading(this.entryListPanel);
        if (entryCount == 1) {
            this.updateAllEntryComponents();
        }
    }
}

