/*
 * Decompiled with CFR 0.152.
 */
package nightmare2;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import nightmare2.App;
import nightmare2.Common_Dialogs;
import nightmare2.ModulePane;
import nightmare2.StructPane;
import org.jdesktop.application.FrameView;

public class ModuleFrame
extends FrameView {
    private static App app = App.getApplication();
    private static ModuleFrame instance;
    private static LinkedList<File> openModules;
    private static boolean problem;
    private JPanel moduleComboBoxPanel;
    private JComboBox moduleComboBox;
    private StructPane pane;
    private boolean ready = false;

    public void pack() {
        if (this.pane == null) {
            return;
        }
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int threeFourthsWidth = screenWidth * 3 / 4;
        int threeFourthsHeight = screenHeight * 3 / 4;
        JFrame frame = this.getFrame();
        frame.setTitle(this.pane.getModuleName());
        frame.setLocationRelativeTo(null);
        frame.setMinimumSize(null);
        frame.setMaximumSize(null);
        frame.pack();
        int extraWidth = this.pane.extraWidth();
        int extraHeight = this.pane.extraHeight();
        int width = frame.getPreferredSize().width;
        int height = frame.getPreferredSize().height;
        width += extraWidth;
        if ((height += extraHeight) > threeFourthsHeight) {
            height = threeFourthsHeight;
        }
        if (width > threeFourthsWidth) {
            width = threeFourthsWidth;
        }
        frame.setSize(new Dimension(width, height));
        frame.setMinimumSize(frame.getSize());
        frame.setMaximumSize(new Dimension(screenWidth, frame.getSize().height));
        frame.repaint();
    }

    private void setModulePane(File moduleFile, Integer baseAddress, ModuleFrame instanceToUse) {
        if (instanceToUse == null) {
            instanceToUse = instance;
        }
        StructPane paneInstance = null;
        paneInstance = baseAddress == null ? new ModulePane(instance, ModuleFrame.instance.moduleComboBoxPanel, moduleFile) : new StructPane(instanceToUse, moduleFile, baseAddress);
        instanceToUse.setComponent(paneInstance);
        paneInstance.repaint();
        this.pane = paneInstance;
        this.pack();
    }

    protected static void instanceHelper(final boolean struct, final File input, final Integer baseAddress) {
        problem = false;
        SwingWorker<Void, Void> moduleThread = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    if (!struct) {
                        instance = new ModuleFrame(false, null, null);
                        instance.setModulePane((File)openModules.peekFirst(), null, null);
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                app.show(instance);
                                instance.pack();
                            }
                        });
                    } else {
                        final ModuleFrame instanceHandle = new ModuleFrame(true, input, baseAddress);
                        instanceHandle.setModulePane(input, baseAddress, instanceHandle);
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                app.show(instanceHandle);
                                instanceHandle.pack();
                            }
                        });
                    }
                }
                catch (Exception e) {
                    problem = true;
                }
                return null;
            }
        };
        moduleThread.execute();
    }

    protected static void newInstance() {
        ModuleFrame.instanceHelper(false, null, null);
    }

    public static void newStruct(File input, int baseAddress) {
        ModuleFrame.instanceHelper(true, input, baseAddress);
    }

    private ModuleFrame(boolean struct, File input, Integer baseAddress) {
        super(app);
        final ModuleFrame curr = this;
        if (struct) {
            JFrame frame = this.getFrame();
            frame.addWindowListener(new WindowListener(){

                @Override
                public void windowOpened(WindowEvent e) {
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    app.hide(curr);
                    curr.getFrame().dispose();
                }

                @Override
                public void windowClosed(WindowEvent e) {
                }

                @Override
                public void windowIconified(WindowEvent e) {
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                }

                @Override
                public void windowActivated(WindowEvent e) {
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                }
            });
            frame.setLocationRelativeTo(null);
            this.ready = true;
            return;
        }
        this.moduleComboBox = new JComboBox();
        this.moduleComboBox.setEditable(false);
        for (File currModule : openModules) {
            this.moduleComboBox.addItem(currModule.getName());
        }
        this.moduleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    File curr = (File)openModules.get(ModuleFrame.this.moduleComboBox.getSelectedIndex());
                    ModuleFrame.this.setModulePane(curr, null, null);
                }
                catch (Exception e) {
                    return;
                }
            }
        });
        this.moduleComboBoxPanel = new JPanel();
        this.moduleComboBoxPanel.add(this.moduleComboBox);
        JButton unloadButton = new JButton("Unload");
        unloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (openModules.size() <= 1) {
                    ModuleFrame.resetOpenModules();
                    return;
                }
                int selected = ModuleFrame.this.moduleComboBox.getSelectedIndex();
                openModules.remove(selected);
                ModuleFrame.this.moduleComboBox.removeItemAt(selected);
                ModuleFrame.this.setModulePane((File)openModules.peekFirst(), null, null);
                ModuleFrame.this.moduleComboBox.setSelectedIndex(0);
            }
        });
        this.moduleComboBoxPanel.add(unloadButton);
        JFrame frame = this.getFrame();
        frame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                ModuleFrame.resetOpenModules();
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.moduleComboBox.setSelectedIndex(0);
        frame.setLocationRelativeTo(null);
        this.ready = true;
    }

    public static File[] getOpenModules() {
        File[] output = new File[openModules.size()];
        int i = 0;
        for (File currFile : openModules) {
            output[i++] = currFile;
        }
        return output;
    }

    public static void resetOpenModules() {
        openModules = new LinkedList();
        if (instance != null) {
            app.hide(instance);
            instance.getFrame().dispose();
        }
        instance = null;
    }

    public static void addModule(File input, boolean update) {
        if (!input.isFile()) {
            return;
        }
        int index = -1;
        int tempIndex = -1;
        for (File curr : openModules) {
            ++tempIndex;
            if (!curr.getPath().equals(input.getPath())) continue;
            index = tempIndex;
            break;
        }
        if (index != -1 && instance != null && update) {
            ModuleFrame.instance.moduleComboBox.setSelectedIndex(index);
            instance.setModulePane(input, null, null);
        }
        openModules.add(input);
        if (update && instance == null) {
            ModuleFrame.newInstance();
        }
        if (instance != null) {
            ModuleFrame.instance.moduleComboBox.addItem(input.getName());
            if (update) {
                ModuleFrame.instance.moduleComboBox.setSelectedIndex(ModuleFrame.instance.moduleComboBox.getItemCount() - 1);
                instance.setModulePane(openModules.peekLast(), null, null);
            }
        }
    }

    public static void addModule(File input) {
        ModuleFrame.addModule(input, true);
    }

    public static void start() {
        if (instance == null && openModules.size() > 0) {
            ModuleFrame.newInstance();
        }
        if (instance == null || openModules.size() <= 0) {
            return;
        }
        instance.setModulePane(openModules.peekFirst(), null, null);
        ModuleFrame.instance.moduleComboBox.setSelectedIndex(0);
    }

    public static void openModule() {
        File dirFile = Common_Dialogs.showOpenFileDialog("module file");
        File dir = dirFile.getParentFile();
        if (dirFile == null || dir == null) {
            return;
        }
        File[] selectedFiles = dir.listFiles();
        if (selectedFiles == null) {
            return;
        }
        int index = -1;
        int count = 0;
        for (File currFile : selectedFiles) {
            if (currFile.getName().indexOf(".nmm") != currFile.getName().length() - 4) continue;
            ModuleFrame.addModule(currFile, false);
            if (currFile.getPath().equals(dirFile.getPath())) {
                index = count;
            }
            ++count;
        }
        selectedFiles = ModuleFrame.getOpenModules();
        if (selectedFiles != null && selectedFiles.length > 0 && index != -1) {
            if (instance == null) {
                ModuleFrame.newInstance();
            }
            instance.setModulePane(dirFile, null, null);
            ModuleFrame.instance.moduleComboBox.setSelectedIndex(ModuleFrame.instance.moduleComboBox.getItemCount() - count + index);
        }
    }

    public static ModuleFrame getInstance() {
        return instance;
    }

    static {
        openModules = new LinkedList();
    }
}

