/*
 * Decompiled with CFR 0.152.
 */
package nightmare2;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JOptionPane;

public class Common_Dialogs {
    public static void showGenericErrorDialog(String message) {
        System.out.println(message);
    }

    public static <E extends Exception> void showCatchErrorDialog(E e) {
        if (e == null) {
            return;
        }
        StackTraceElement[] stackTrace = e.getStackTrace();
        StackTraceElement exceptSource = stackTrace[0];
        String methodName = exceptSource.getClassName() + "." + exceptSource.getMethodName();
        String exceptMessage = e.getMessage();
        if (exceptMessage == null) {
            exceptMessage = "Unknown exception";
        }
        exceptMessage = "\t" + exceptMessage.replaceAll("\n", "\n\t");
        String message = methodName + ":\n" + exceptMessage;
        Common_Dialogs.showGenericErrorDialog(message);
    }

    public static void showGenericInformationDialog(String message) {
        JOptionPane.showMessageDialog(null, message, "Notice", 1);
    }

    public static int showYesNoDialog(String message) {
        return JOptionPane.showConfirmDialog(null, message, "Input", 0);
    }

    private static File fileHelper(String title, int mode) {
        FileDialog chooser = new FileDialog(new Frame(), title, mode);
        chooser.setVisible(true);
        chooser.setLocationRelativeTo(null);
        if (chooser.getDirectory() == null || chooser.getFile() == null) {
            return null;
        }
        String inputFileName = chooser.getDirectory() + chooser.getFile();
        return new File(inputFileName);
    }

    public static File showOpenFileDialog(String what) {
        return Common_Dialogs.fileHelper("Select " + what + " for opening", 0);
    }

    public static File showSaveFileDialog(String what) {
        return Common_Dialogs.fileHelper("Select path to save " + what, 1);
    }
}

