/*
 * Decompiled with CFR 0.152.
 */
package Model;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;

public class Util {
    public static String newline() {
        return System.getProperty("line.separator");
    }

    public static int parseInt(String input) {
        input = input.trim();
        int base = 10;
        if (input.indexOf("0x") == 0) {
            base = 16;
            input = input.substring(2);
        }
        return Integer.parseInt(input, base);
    }

    public static byte[] bytesToBytes(byte[] ... arrays) {
        int size = 0;
        for (byte[] array : arrays) {
            size += array.length;
        }
        byte[] result = new byte[size];
        int position = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, result, position, array.length);
            position += array.length;
        }
        return result;
    }

    public static byte[] shortsToBytes(short[] ... arrays) {
        int size = 0;
        for (short[] array : arrays) {
            size += array.length;
        }
        byte[] result = new byte[size * 2];
        int position = 0;
        short[][] arr$ = arrays;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            short[] array;
            for (short value : array = arr$[i$]) {
                result[position++] = (byte)value;
                result[position++] = (byte)(value >> 8);
            }
        }
        return result;
    }

    public static byte[] intsToBytes(int[] ... arrays) {
        int size = 0;
        for (int[] array : arrays) {
            size += array.length;
        }
        byte[] result = new byte[size * 4];
        int position = 0;
        int[][] arr$ = arrays;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[] array;
            for (int value : array = arr$[i$]) {
                result[position++] = (byte)value;
                result[position++] = (byte)(value >> 8);
                result[position++] = (byte)(value >> 16);
                result[position++] = (byte)(value >> 24);
            }
        }
        return result;
    }

    public static short[] bytesToShorts(byte[] ... arrays) {
        int size = 0;
        for (byte[] array : arrays) {
            size += array.length;
        }
        short[] result = new short[(size + 1) / 2];
        int position = 0;
        int sub_position = 0;
        byte[][] arr$ = arrays;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte[] array;
            for (byte value : array = arr$[i$]) {
                int n = position++;
                result[n] = (short)(result[n] | (value & 0xFF) << sub_position * 8);
                if (++sub_position != 2) continue;
                sub_position = 0;
            }
        }
        return result;
    }

    public static short[] shortsToShorts(short[] ... arrays) {
        int size = 0;
        for (short[] array : arrays) {
            size += array.length;
        }
        short[] result = new short[size];
        int position = 0;
        for (short[] array : arrays) {
            System.arraycopy(array, 0, result, position, array.length);
            position += array.length;
        }
        return result;
    }

    public static short[] intsToShorts(int[] ... arrays) {
        int size = 0;
        for (int[] array : arrays) {
            size += array.length;
        }
        short[] result = new short[size * 2];
        int position = 0;
        int[][] arr$ = arrays;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[] array;
            for (int value : array = arr$[i$]) {
                result[position++] = (short)value;
                result[position++] = (short)(value >> 16);
            }
        }
        return result;
    }

    public static int[] bytesToInts(byte[] ... arrays) {
        int size = 0;
        for (byte[] array : arrays) {
            size += array.length;
        }
        int[] result = new int[(size + 3) / 4];
        int position = 0;
        int sub_position = 0;
        byte[][] arr$ = arrays;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte[] array;
            for (byte value : array = arr$[i$]) {
                int n = position++;
                result[n] = result[n] | (value & 0xFF) << sub_position * 8;
                if (++sub_position != 4) continue;
                sub_position = 0;
            }
        }
        return result;
    }

    public static int[] shortsToInts(short[] ... arrays) {
        int size = 0;
        for (short[] array : arrays) {
            size += array.length;
        }
        int[] result = new int[(size + 1) / 2];
        int position = 0;
        int sub_position = 0;
        short[][] arr$ = arrays;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            short[] array;
            for (short value : array = arr$[i$]) {
                int n = position++;
                result[n] = result[n] | (value & 0xFFFF) << sub_position * 16;
                if (++sub_position != 2) continue;
                sub_position = 0;
            }
        }
        return result;
    }

    public static int[] intsToInts(int[] ... arrays) {
        int size = 0;
        for (int[] array : arrays) {
            size += array.length;
        }
        int[] result = new int[size];
        int position = 0;
        for (int[] array : arrays) {
            System.arraycopy(array, 0, result, position, array.length);
            position += array.length;
        }
        return result;
    }

    public static int findByteString(byte[] data, byte byteToFind, int length) {
        if (data == null || length < 0 || length > data.length) {
            return -1;
        }
        if (length == 0) {
            return 0;
        }
        int index = -1;
        int areaNeeded = length;
        int areaFound = 0;
        block0: for (int i = 0; i < data.length - areaNeeded; i += 4) {
            if (areaFound != 0) {
                i += areaFound - 1;
                i >>= 2;
                if ((i <<= 2) >= data.length) break;
            }
            areaFound = 0;
            if (data[i] != byteToFind) continue;
            while (data[i + areaFound] == byteToFind) {
                if (++areaFound < areaNeeded) continue;
                index = i;
                break block0;
            }
        }
        return index;
    }

    public static String condenseCharacterCodes(String input) {
        for (int i = 0; i < 32; ++i) {
            input = input.replace(String.format("\\u%04X", i), String.format("%c", Character.valueOf((char)i)));
        }
        return input;
    }

    public static String expandCharacterCodes(String input) {
        for (int i = 0; i < 32; ++i) {
            input = input.replace(String.format("%c", Character.valueOf((char)i)), String.format("\\u%04X", i));
        }
        return input;
    }

    public static byte[] stringToByteArray(String input, int byteCount) {
        if (input == null || byteCount <= 0) {
            return null;
        }
        input = input.trim();
        LinkedList<Byte> outputList = new LinkedList<Byte>();
        while (input.length() > 0) {
            String tempString;
            int spaceIndex = input.indexOf(" ");
            if (spaceIndex != -1) {
                tempString = input.substring(0, spaceIndex);
                input = input.substring(spaceIndex + 1);
            } else {
                tempString = input;
                input = "";
            }
            try {
                int tempInt = Integer.parseInt(tempString, 16);
                if (tempInt < 0 || tempInt > 255) {
                    return null;
                }
                outputList.add(new Integer(tempInt).byteValue());
            }
            catch (Exception e) {
                return null;
            }
        }
        if (outputList.size() != byteCount) {
            return null;
        }
        byte[] output = new byte[outputList.size()];
        int i = 0;
        for (Byte currByte : outputList) {
            output[i++] = currByte;
        }
        return output;
    }

    public static String byteArrayToString(byte[] input) {
        if (input == null || input.length == 0) {
            return null;
        }
        String outputString = " ";
        for (int i = 0; i < input.length; ++i) {
            outputString = outputString + String.format("%02X ", input[i] & 0xFF);
        }
        return outputString.substring(0, outputString.length() - 1);
    }

    public static void renameDuplicates(String[] input) {
        HashSet<String> dejaVu = new HashSet<String>();
        Hashtable<String, Integer> duplicates = new Hashtable<String, Integer>();
        for (String s : input) {
            if (dejaVu.contains(s)) {
                duplicates.put(s, 1);
                continue;
            }
            dejaVu.add(s);
        }
        for (int i = 0; i < input.length; ++i) {
            if (duplicates.get(input[i]) == null) continue;
            int ID = (Integer)duplicates.get(input[i]);
            duplicates.put(input[i], ID + 1);
            int n = i;
            input[n] = input[n] + " " + ID;
        }
    }

    public static long mask(int bits) {
        return (1L << (int)((long)bits)) - 1L;
    }

    public static void main(String[] args) {
        byte[] byte1 = new byte[]{1};
        byte[] byte2 = new byte[]{2, 3};
        byte[] byte3 = new byte[]{4, 5, 6, 7};
        short[] short1 = new short[]{32513};
        short[] short2 = new short[]{32258, 32003};
        short[] short3 = new short[]{31748, 31493, 31238, 30983};
        int[] int1 = new int[]{2130706433};
        int[] int2 = new int[]{2113929218, 2097152003};
        int[] int3 = new int[]{2080374788, 2063597573, 2046820358, 0x79000007};
        for (int v : Util.bytesToBytes(byte1, byte2, byte3)) {
            System.out.print(String.format("%02X ", (byte)v));
        }
        System.out.println();
        for (int v : Util.bytesToShorts(byte1, byte2, byte3)) {
            System.out.print(String.format("%04X ", (short)v));
        }
        System.out.println();
        for (int v : Util.bytesToInts(byte1, byte2, byte3)) {
            System.out.print(String.format("%08X ", v));
        }
        System.out.println();
        for (int v : Util.shortsToBytes(short1, short2, short3)) {
            System.out.print(String.format("%02X ", (byte)v));
        }
        System.out.println();
        for (int v : Util.shortsToShorts(short1, short2, short3)) {
            System.out.print(String.format("%04X ", (short)v));
        }
        System.out.println();
        for (int v : Util.shortsToInts(short1, short2, short3)) {
            System.out.print(String.format("%08X ", v));
        }
        System.out.println();
        for (int v : Util.intsToBytes(int1, int2, int3)) {
            System.out.print(String.format("%02X ", (byte)v));
        }
        System.out.println();
        for (int v : Util.intsToShorts(int1, int2, int3)) {
            System.out.print(String.format("%04X ", (short)v));
        }
        System.out.println();
        for (int v : Util.intsToInts(int1, int2, int3)) {
            System.out.print(String.format("%08X ", v));
        }
    }
}

