/*
 * Decompiled with CFR 0.152.
 */
package Model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.zip.CRC32;

public class Target_File {
    private static boolean open = false;
    private static boolean named = false;
    private static boolean saved = true;
    private static String fileName = "";
    private static ByteSex endianness = ByteSex.LITTLE;
    private static byte[] data;
    private static boolean originalLittleChecksumValid;
    private static boolean originalBigChecksumValid;
    private static int originalChecksum;

    private Target_File() {
    }

    public static boolean isOpen() {
        return open;
    }

    private static int checksum(byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        return (int)crc32.getValue();
    }

    public static int checksum() {
        return Target_File.checksum(data);
    }

    public static String iniPath() {
        int checksum = Target_File.checksum();
        return new File(fileName).getParent() + File.separator + String.format("%08X.ini", checksum);
    }

    public static int size() {
        return data.length;
    }

    public static boolean isNamed() {
        return named;
    }

    public static boolean isSaved() {
        return saved;
    }

    public static String fileName() {
        return fileName;
    }

    public static ByteSex endianness() {
        return endianness;
    }

    public static void setLittleEndian() {
        endianness = ByteSex.LITTLE;
    }

    public static void setBigEndian() {
        endianness = ByteSex.BIG;
    }

    private static void verifyOpenFile() {
        if (!open) {
            throw new RuntimeException("no file open");
        }
    }

    public static AccessType calculateAccessType(int significand, boolean bitAddress) {
        int shiftAmt = 0;
        if (bitAddress) {
            shiftAmt = 3;
        }
        int byteChk = 1 << shiftAmt;
        int halfChk = 2 << shiftAmt;
        int wordChk = 4 << shiftAmt;
        if (significand % wordChk == 0) {
            return AccessType.WORD;
        }
        if (significand % halfChk == 0) {
            return AccessType.HALF;
        }
        if (significand % byteChk == 0) {
            return AccessType.BYTE;
        }
        return AccessType.BIT;
    }

    public static byte getByte(int address) {
        Target_File.verifyOpenFile();
        return data[address];
    }

    public static short getShort(int address) {
        short tempShort;
        Target_File.verifyOpenFile();
        if (address % 2 != 0) {
            throw new Target_File().new AlignmentException();
        }
        if (endianness == ByteSex.LITTLE) {
            tempShort = (short)((data[address + 1] & 0xFF) << 8);
            tempShort = (short)(tempShort | data[address] & 0xFF);
        } else {
            tempShort = (short)(data[address + 1] & 0xFF);
            tempShort = (short)(tempShort | (data[address] & 0xFF) << 8);
        }
        return tempShort;
    }

    public static int getInt(int address) {
        int tempInt;
        Target_File.verifyOpenFile();
        if (address % 4 != 0) {
            throw new Target_File().new AlignmentException();
        }
        if (endianness == ByteSex.LITTLE) {
            tempInt = (data[address + 3] & 0xFF) << 24;
            tempInt |= (data[address + 2] & 0xFF) << 16;
            tempInt |= (data[address + 1] & 0xFF) << 8;
            tempInt |= data[address] & 0xFF;
        } else {
            tempInt = data[address + 3] & 0xFF;
            tempInt |= (data[address + 2] & 0xFF) << 8;
            tempInt |= (data[address + 1] & 0xFF) << 16;
            tempInt |= (data[address] & 0xFF) << 24;
        }
        return tempInt;
    }

    public static void putByte(int address, byte input) {
        Target_File.verifyOpenFile();
        Target_File.data[address] = input;
        saved = false;
    }

    public static void putShort(int address, short input) {
        Target_File.verifyOpenFile();
        if (address % 2 != 0) {
            throw new Target_File().new AlignmentException();
        }
        if (endianness == ByteSex.LITTLE) {
            Target_File.data[address + 1] = (byte)(input >> 8);
            Target_File.data[address] = (byte)(input & 0xFF);
        } else {
            Target_File.data[address] = (byte)(input >> 8);
            Target_File.data[address + 1] = (byte)(input & 0xFF);
        }
        saved = false;
    }

    public static void putInt(int address, int input) {
        Target_File.verifyOpenFile();
        if (address % 4 != 0) {
            throw new Target_File().new AlignmentException();
        }
        if (endianness == ByteSex.LITTLE) {
            Target_File.data[address + 3] = (byte)(input >> 24);
            Target_File.data[address + 2] = (byte)(input >> 16 & 0xFF);
            Target_File.data[address + 1] = (byte)(input >> 8 & 0xFF);
            Target_File.data[address] = (byte)(input & 0xFF);
        } else {
            Target_File.data[address] = (byte)(input >> 24);
            Target_File.data[address + 1] = (byte)(input >> 16 & 0xFF);
            Target_File.data[address + 2] = (byte)(input >> 8 & 0xFF);
            Target_File.data[address + 3] = (byte)(input & 0xFF);
        }
        saved = false;
    }

    public static int getBits(int address, int offset, int length) {
        Target_File.verifyOpenFile();
        if (length > 32 || length <= 0) {
            throw new IllegalArgumentException("invalid length");
        }
        int output = 0;
        while (length > 0) {
            if (offset == 8) {
                ++address;
            }
            output <<= 1;
            output |= (data[address] & 1 << 7 - (offset %= 8)) >> 7 - offset;
            ++offset;
            --length;
        }
        return output;
    }

    public static void putBits(int address, int offset, int length, int input) {
        Target_File.verifyOpenFile();
        if (length > 32 || length <= 0) {
            throw new IllegalArgumentException("invalid length");
        }
        int mask = 1 << length - 1;
        while (length > 0) {
            if (offset == 8) {
                ++address;
            }
            Target_File.data[address] = (byte)(data[address] & ~(1 << 7 - (offset %= 8)) | (input & mask) >> length - 1 << 7 - offset);
            saved = false;
            ++offset;
            mask >>= 1;
            --length;
        }
    }

    public static byte[] getData() {
        Target_File.verifyOpenFile();
        return data;
    }

    public static boolean isValid(int checksum) {
        Target_File.verifyOpenFile();
        if (originalLittleChecksumValid && endianness == ByteSex.LITTLE) {
            return true;
        }
        if (originalBigChecksumValid && endianness == ByteSex.BIG) {
            return true;
        }
        return originalChecksum == checksum;
    }

    public static String pullString(byte[] source, int start, int end) {
        Target_File.verifyOpenFile();
        String tempString = "";
        try {
            tempString = new String(Arrays.copyOfRange(source, start, end), "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return tempString;
    }

    public static void putString(byte[] dest, int start, String input) {
        Target_File.verifyOpenFile();
        byte[] inputArray = new byte[input.length()];
        for (int i = 0; i < inputArray.length; ++i) {
            inputArray[i] = (byte)input.charAt(i);
        }
        System.arraycopy(inputArray, 0, data, start, inputArray.length);
        if (dest == data) {
            saved = false;
        }
    }

    public static void open(File input) {
        FileInputStream inputFile;
        saved = true;
        if (input == null || !input.exists()) {
            open = false;
            throw new IllegalArgumentException("invalid file");
        }
        try {
            inputFile = new FileInputStream(input);
            data = new byte[(int)input.length()];
            inputFile.read(data);
        }
        catch (IOException e) {
            open = false;
            throw new IllegalArgumentException("stream error");
        }
        open = true;
        fileName = input.getPath();
        try {
            inputFile.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        Target_File.expand(0);
        originalLittleChecksumValid = false;
        originalBigChecksumValid = false;
        originalChecksum = Target_File.checksum();
        int modifiedChecksum = Target_File.checksum(Arrays.copyOf(data, data.length - 4));
        endianness = ByteSex.LITTLE;
        int originalLittleChecksum = Target_File.getInt(data.length - 4);
        if (originalLittleChecksum == modifiedChecksum) {
            originalLittleChecksumValid = true;
        }
        endianness = ByteSex.BIG;
        int originalBigChecksum = Target_File.getInt(data.length - 4);
        if (originalBigChecksum == modifiedChecksum) {
            originalBigChecksumValid = true;
        }
        endianness = ByteSex.LITTLE;
        if (originalLittleChecksumValid || originalBigChecksumValid) {
            Target_File.expand(-4);
        }
    }

    public static void save(File where) {
        FileOutputStream outputFile;
        Target_File.verifyOpenFile();
        int checksum = Target_File.checksum();
        Target_File.expand(4);
        Target_File.putInt(data.length - 4, checksum);
        if (where == null || !where.exists()) {
            Target_File.expand(-4);
            return;
        }
        try {
            outputFile = new FileOutputStream(where);
            outputFile.write(data);
        }
        catch (IOException e) {
            Target_File.expand(-4);
            throw new IllegalArgumentException("stream error");
        }
        saved = true;
        named = true;
        fileName = where.getPath();
        try {
            outputFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Target_File.expand(-4);
    }

    public static int expand(int amount) {
        Target_File.verifyOpenFile();
        int originalSize = data.length;
        int size = originalSize + amount + 3;
        size >>= 2;
        data = Arrays.copyOf(data, size <<= 2);
        return size - originalSize;
    }

    public static int append(byte[] input) {
        Target_File.verifyOpenFile();
        int address = data.length;
        int tempInt = Target_File.expand(input.length);
        System.arraycopy(input, 0, data, data.length - tempInt, input.length);
        return address;
    }

    public static int writeToFile(byte[] input) {
        Target_File.verifyOpenFile();
        int address = data.length;
        Target_File.append(input);
        saved = false;
        return address;
    }

    public static void overwriteFile(byte[] input, int address) {
        Target_File.verifyOpenFile();
        System.arraycopy(input, 0, data, address, input.length);
        saved = false;
    }

    public static int writeAndRepoint(byte[] input, int pointerAddress) {
        Target_File.verifyOpenFile();
        int address = Target_File.writeToFile(input);
        Target_File.putInt(pointerAddress, address);
        address = pointerAddress;
        return address;
    }

    public static void findAndReplace(int oldVal, int newVal) {
        Target_File.verifyOpenFile();
        for (int i = 0; i < data.length; i += 4) {
            if (Target_File.getInt(i) != oldVal) continue;
            Target_File.putInt(i, newVal);
        }
        saved = false;
    }

    public static void closeFile() {
        open = false;
        data = null;
        named = false;
        saved = true;
        fileName = "";
        originalLittleChecksumValid = false;
        originalBigChecksumValid = false;
        originalChecksum = 0;
    }

    class AlignmentException
    extends RuntimeException {
        AlignmentException() {
        }
    }

    public static enum AccessType {
        BYTE,
        HALF,
        WORD,
        BIT;

    }

    public static enum ByteSex {
        LITTLE,
        BIG;

    }
}

