/*
 * Decompiled with CFR 0.152.
 */
package Model;

import Model.Target_File;
import Model.Util;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Scanner;

public class Module {
    private static boolean numBitsOffsetErrorDisplayed = false;
    private static boolean bitCountErrorDisplayed = false;
    private static boolean tooManyBitsErrorDisplayed = false;
    private static boolean arrayTypeErrorDisplayed = false;
    private static boolean structErrorDisplayed = false;
    protected File thisModule = null;
    private boolean valid = true;
    private int line = 1;
    private String errorString = "";
    protected boolean useBasePointer = false;
    protected boolean expanded = false;
    private int hardwareOffset = 0;
    private Integer checksum;
    private String IDstring;
    private Integer IDstringAddress;
    protected String version;
    protected String description;
    protected int baseAddress;
    protected int basePointer;
    protected int defaultEntryCount;
    protected int expandedEntryCount;
    protected int entrySize;
    private File entryList;
    private File textTable;
    private LinkedList<TextTableEntry> textTableEntryList = new LinkedList();
    private TextTableEntry[] textTableTranslationEntries;
    private TextTableEntry[] textTableEncodingEntries;
    private LinkedList<EntryComponent> componentList = new LinkedList();

    private static final int partitionTableEntries(TextTableEntry[] array, int left, int right, boolean replaceElements) {
        TextTableEntry temp;
        int storeIndex = right;
        int rightComparator = !replaceElements ? array[left].findLength : array[left].replaceLength;
        for (int i = right; i > left; --i) {
            int leftComparator = !replaceElements ? array[i].findLength : array[i].replaceLength;
            if (leftComparator >= rightComparator) continue;
            temp = array[i];
            array[i] = array[storeIndex];
            array[storeIndex--] = temp;
        }
        temp = array[left];
        array[left] = array[storeIndex];
        array[storeIndex] = temp;
        return storeIndex;
    }

    private static final void quickSortTableEntries(TextTableEntry[] array, int left, int right, boolean replaceElements) {
        if (array == null) {
            return;
        }
        if (right <= left) {
            return;
        }
        int pivotNewIndex = Module.partitionTableEntries(array, left, right, replaceElements);
        Module.quickSortTableEntries(array, left, pivotNewIndex - 1, replaceElements);
        Module.quickSortTableEntries(array, pivotNewIndex + 1, right, replaceElements);
    }

    private final String nextRelevantLine(Scanner input) {
        String tempString;
        try {
            tempString = input.findWithinHorizon(".", 1);
            while (tempString == null && input.hasNext() || tempString.equals("#")) {
                input.nextLine();
                ++this.line;
                tempString = input.findWithinHorizon(".", 1);
            }
            if (!input.hasNext()) {
                throw new RuntimeException("unexpected end of file");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("unknown processing error");
        }
        return tempString + input.nextLine();
    }

    private final int getInt(Scanner input) {
        return this.getInt(input, false);
    }

    private final int getInt(Scanner input, Boolean silentlyFail) {
        String originalString = this.nextRelevantLine(input);
        int retVal = -1;
        boolean negative = false;
        try {
            String loadedString = originalString;
            if (loadedString.charAt(0) == '-') {
                loadedString = loadedString.substring(1);
                negative = true;
            }
            int base = 10;
            if (loadedString.indexOf("0x") == 0) {
                base = 16;
                loadedString = loadedString.substring(2);
            }
            retVal = Integer.parseInt(loadedString, base);
        }
        catch (Exception e) {
            if (!silentlyFail.booleanValue() || !input.hasNext()) {
                this.addGeneralError(originalString);
                this.valid = false;
                retVal = -1;
            }
            silentlyFail = true;
        }
        ++this.line;
        if (this.valid && negative) {
            retVal = 0 - retVal;
        }
        return retVal;
    }

    private final void addToErrorString(String input, boolean general) {
        this.errorString = general ? this.errorString + "Line " + this.line + ": Error parsing \"" + input + "\"" : this.errorString + input + "\n";
    }

    private final void addToErrorString(String input) {
        this.addToErrorString(input, false);
    }

    private final void addGeneralError(String input) {
        this.addToErrorString(input, true);
    }

    private final void processChecksum(Scanner theModule) {
        if (theModule.findWithinHorizon("#0x", 3) != null) {
            long checksumVal = -1L;
            String checksumString = theModule.nextLine();
            try {
                checksumVal = Long.parseLong(checksumString, 16);
                if ((checksumVal & 0xFFFFFFFF00000000L) != 0L) {
                    throw new Exception();
                }
                this.checksum = (int)checksumVal;
            }
            catch (Exception e) {
                throw new RuntimeException("checksum line is invalid; no checksum is being used.");
            }
            if (!Target_File.isValid(this.checksum)) {
                this.valid = false;
                throw new RuntimeException("File has invalid checksum for use with this module.");
            }
            ++this.line;
        }
    }

    private final void processIDstring(Scanner theModule) {
        if (theModule.findWithinHorizon("#0x", 3) != null) {
            long IDaddress = -1L;
            String loadedString = theModule.nextLine();
            try {
                IDaddress = Long.parseLong(loadedString, 16);
                if (IDaddress < 0L || IDaddress >= (long)Target_File.size()) {
                    throw new Exception();
                }
                this.IDstringAddress = (int)IDaddress;
            }
            catch (Exception e) {
                ++this.line;
                throw new RuntimeException("ID string address line is invalid; no ID string is being used.");
            }
            ++this.line;
            this.IDstring = theModule.nextLine();
            this.IDstring = this.IDstring.substring(1);
            this.IDstring = Util.condenseCharacterCodes(this.IDstring);
            if (this.IDstring.length() + this.IDstringAddress > Target_File.size()) {
                throw new RuntimeException("ID string line is too long; no ID string is being used.");
            }
            if (!Target_File.pullString(Target_File.getData(), this.IDstringAddress, this.IDstringAddress + this.IDstring.length()).equals(this.IDstring)) {
                this.valid = false;
                throw new RuntimeException("ID string line doesn't match ID string in file;\ncancelling module loading.");
            }
            ++this.line;
        }
    }

    private final void processBasePointerExpected(Scanner theModule) {
        if (theModule.findWithinHorizon("#BASEPOINTER", 12) != null) {
            this.useBasePointer = true;
            theModule.nextLine();
            ++this.line;
        }
    }

    private final void processTextTableEntries() {
        Scanner textTableScanner;
        if (this.textTable == null) {
            return;
        }
        try {
            textTableScanner = new Scanner(this.textTable);
        }
        catch (Exception e) {
            throw new RuntimeException("Text table file failed to load;\ntext tokens will not be translated");
        }
        int count = 0;
        while (textTableScanner.hasNext()) {
            String loadedString = textTableScanner.nextLine();
            int assignmentOperatorIndex = loadedString.indexOf(" = ");
            if (assignmentOperatorIndex == -1) continue;
            this.textTableEntryList.add(new TextTableEntry(Util.condenseCharacterCodes(loadedString.substring(0, assignmentOperatorIndex)), Util.condenseCharacterCodes(loadedString.substring(assignmentOperatorIndex + 3))));
            if (this.textTableEntryList.peekLast().findLength == 0 || this.textTableEntryList.peekLast().replaceLength == 0) {
                this.textTableEntryList.removeLast();
                continue;
            }
            ++count;
        }
        try {
            textTableScanner.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.textTableTranslationEntries = new TextTableEntry[count];
        this.textTableEncodingEntries = new TextTableEntry[count];
        int i = 0;
        Iterator i$ = this.textTableEntryList.iterator();
        while (i$.hasNext()) {
            TextTableEntry currEntry;
            this.textTableTranslationEntries[i] = currEntry = (TextTableEntry)i$.next();
            this.textTableEncodingEntries[i++] = currEntry;
        }
        Module.quickSortTableEntries(this.textTableTranslationEntries, 0, i - 1, true);
        Module.quickSortTableEntries(this.textTableEncodingEntries, 0, i - 1, false);
    }

    private final void processHeader(Scanner theModule) {
        String loadedString = this.nextRelevantLine(theModule);
        if (loadedString == null) {
            this.valid = false;
            return;
        }
        this.version = loadedString;
        ++this.line;
        loadedString = this.nextRelevantLine(theModule);
        if (loadedString == null) {
            this.valid = false;
            return;
        }
        this.description = loadedString;
        ++this.line;
        this.baseAddress = this.getInt(theModule);
        if (this.baseAddress < 0 || this.baseAddress > Target_File.size()) {
            this.valid = false;
            throw new IllegalArgumentException("invalid base address");
        }
        if (theModule.findWithinHorizon("#", 1) != null) {
            this.hardwareOffset = this.getInt(theModule, true);
        }
        if (this.useBasePointer) {
            this.basePointer = theModule.findWithinHorizon("#", 1) == null ? -1 : this.getInt(theModule);
            if (this.basePointer < 0 || this.basePointer > Target_File.size()) {
                this.valid = false;
                throw new IllegalArgumentException("invalid base pointer");
            }
            int tempInt = Target_File.getInt(this.basePointer) - this.hardwareOffset;
            if (this.useBasePointer && tempInt != this.baseAddress) {
                this.expanded = true;
            }
            this.baseAddress = tempInt;
        }
        this.defaultEntryCount = this.getInt(theModule);
        if (this.defaultEntryCount <= 256) {
            this.expandedEntryCount = 256;
        } else if (this.defaultEntryCount < 65536) {
            this.expandedEntryCount = 65536;
        } else if (this.defaultEntryCount >= 65536) {
            this.addToErrorString("Expansion cannot be supported:\nmaximum value of indexing data type is too large");
            this.expandedEntryCount = this.defaultEntryCount;
        }
        if (this.defaultEntryCount < 0) {
            this.valid = false;
            throw new IllegalArgumentException("invalid default entry count");
        }
        this.entrySize = this.getInt(theModule);
        if (this.entrySize <= 0) {
            this.valid = false;
            throw new IllegalArgumentException("invalid entry size");
        }
        loadedString = this.nextRelevantLine(theModule);
        if (loadedString == null) {
            this.valid = false;
            return;
        }
        if (loadedString.equals("NULL")) {
            this.textTable = null;
        } else {
            this.entryList = new File(this.thisModule.getParent() + File.separator + loadedString);
        }
        ++this.line;
        loadedString = this.nextRelevantLine(theModule);
        if (loadedString == null) {
            this.valid = false;
            return;
        }
        this.textTable = loadedString.equals("NULL") ? null : new File(this.thisModule.getParent() + File.separator + loadedString);
        ++this.line;
        this.processTextTableEntries();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void processValidComponents(Scanner theModule) {
        while (true) {
            int i;
            EntryComponent currentComponent = new EntryComponent();
            String loadedString = this.nextRelevantLine(theModule);
            if (loadedString == null) return;
            currentComponent.setName(loadedString);
            ++this.line;
            if (!currentComponent.isValid()) {
                for (i = 0; i < 4; ++i) {
                    loadedString = this.nextRelevantLine(theModule);
                }
                if (loadedString != null) continue;
                return;
            }
            loadedString = this.nextRelevantLine(theModule);
            if (loadedString == null) return;
            currentComponent.setNumBitsOffset(loadedString);
            ++this.line;
            if (!currentComponent.isValid()) {
                for (i = 0; i < 3; ++i) {
                    loadedString = this.nextRelevantLine(theModule);
                }
                if (loadedString != null) continue;
                return;
            }
            loadedString = this.nextRelevantLine(theModule);
            if (loadedString == null) return;
            currentComponent.setBitCount(loadedString);
            if (currentComponent.getNumBitsOffset() + currentComponent.getBitCount() > this.entrySize << 3) {
                this.addToErrorString("Line " + this.line + ": Warning: Size and/or offset of " + "component extends\nbeyond the entry " + "size for this module");
            }
            ++this.line;
            if (!currentComponent.isValid()) {
                for (i = 0; i < 2; ++i) {
                    loadedString = this.nextRelevantLine(theModule);
                }
                if (loadedString != null) continue;
                return;
            }
            loadedString = this.nextRelevantLine(theModule);
            if (loadedString == null) return;
            currentComponent.setType(loadedString);
            ++this.line;
            if (!currentComponent.isValid()) {
                loadedString = this.nextRelevantLine(theModule);
                if (loadedString != null) continue;
                return;
            }
            loadedString = this.nextRelevantLine(theModule);
            if (loadedString == null) return;
            if (loadedString.equals("NULL")) {
                currentComponent.setAssociatedList(loadedString);
            } else {
                currentComponent.setAssociatedList(this.thisModule.getParent() + File.separator + loadedString);
            }
            ++this.line;
            if (currentComponent.isValid()) {
                this.componentList.add(currentComponent);
            }
            if (!theModule.hasNext()) return;
        }
    }

    public Module(File input) {
        if (input == null) {
            throw new RuntimeException("invalid path");
        }
        Scanner theModule = null;
        try {
            theModule = new Scanner(input);
        }
        catch (Exception e) {
            this.valid = false;
        }
        this.thisModule = input;
        try {
            this.processChecksum(theModule);
            if (this.valid) {
                this.processIDstring(theModule);
            }
            if (this.valid) {
                this.processBasePointerExpected(theModule);
            }
            if (this.valid) {
                this.processHeader(theModule);
            }
            if (this.valid) {
                this.processValidComponents(theModule);
            }
        }
        catch (Exception e) {
            this.errorString = this.errorString + e.getMessage() + "\n";
        }
        try {
            theModule.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.valid) {
            throw new RuntimeException(this.errorString);
        }
    }

    public void expand() {
        if (!this.canExpand()) {
            throw new RuntimeException("attempt to expand non-expandable data");
        }
        int originalSize = this.entrySize * this.defaultEntryCount;
        int expandedSize = this.entrySize * this.expandedEntryCount;
        byte[] thisArray = Arrays.copyOfRange(Target_File.getData(), this.baseAddress, this.baseAddress + originalSize);
        thisArray = Arrays.copyOf(thisArray, expandedSize);
        int cleanBaseAddress = this.baseAddress;
        this.baseAddress = Target_File.writeToFile(thisArray);
        Target_File.findAndReplace(cleanBaseAddress + this.hardwareOffset, this.baseAddress + this.hardwareOffset);
        this.expanded = true;
        byte[] wipedTable = new byte[originalSize];
        Target_File.overwriteFile(wipedTable, cleanBaseAddress);
    }

    public final String translate(String input) {
        if (input == null) {
            return null;
        }
        if (this.textTable == null || this.textTableTranslationEntries.length == 0) {
            return input;
        }
        String outputString = "";
        while (input.length() > 0) {
            boolean match = false;
            for (TextTableEntry currEntry : this.textTableTranslationEntries) {
                if (input.indexOf(currEntry.getFind()) != 0) continue;
                outputString = outputString + currEntry.getReplace();
                input = input.substring(currEntry.getFind().length());
                match = true;
                break;
            }
            if (match) continue;
            outputString = outputString + input.substring(0, 1);
            input = input.substring(1);
        }
        return outputString;
    }

    public final String encode(String input) {
        if (input == null) {
            return null;
        }
        if (this.textTable == null || this.textTableEncodingEntries.length == 0) {
            return input;
        }
        String outputString = "";
        if (input.length() == 0) {
            return outputString;
        }
        while (input.length() > 0) {
            boolean match = false;
            for (TextTableEntry currEntry : this.textTableEncodingEntries) {
                if (input.indexOf(currEntry.getReplace()) != 0) continue;
                outputString = outputString + currEntry.getFind();
                input = input.substring(currEntry.getReplace().length());
                match = true;
                break;
            }
            if (match) continue;
            outputString = outputString + input.substring(0, 1);
            input = input.substring(1);
        }
        return outputString;
    }

    public final String getErrors() {
        return this.errorString;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean canExpand() {
        return !this.expanded && this.expandedEntryCount != this.defaultEntryCount && this.useBasePointer;
    }

    public final String getDescription() {
        return this.description;
    }

    public final int getHardwareOffset() {
        return this.hardwareOffset;
    }

    public int getEntryCount() {
        return this.expanded ? this.expandedEntryCount : this.defaultEntryCount;
    }

    public final File getEntryList() {
        return this.entryList;
    }

    public final LinkedList<EntryComponent> getComponentList() {
        return this.componentList;
    }

    public final void setHardwareOffset(int newOffset) {
        this.hardwareOffset = newOffset;
    }

    public String toString() {
        String outputString = "\n";
        outputString = outputString + "Path: " + this.thisModule.getPath() + "\n";
        outputString = outputString + "Version: " + this.version + "\n";
        outputString = outputString + "Description: " + this.description + "\n";
        outputString = outputString + "Base address: " + String.format("0x%08X", this.baseAddress) + "\n";
        outputString = outputString + "Base pointer: " + String.format("0x%08X", this.basePointer) + "\n";
        outputString = outputString + "Default entry count: " + String.format("0x%X", this.defaultEntryCount) + "\n";
        outputString = outputString + "Expanded entry count: " + String.format("0x%X", this.expandedEntryCount) + "\n";
        outputString = outputString + "Entry size: " + String.format("0x%X", this.entrySize) + "\n";
        outputString = this.entryList != null ? outputString + "Entry list path: " + this.entryList.getPath() + "\n" : outputString + "No entry list\n";
        outputString = this.textTable != null ? outputString + "Text table path: " + this.textTable.getPath() : outputString + "No text table\n";
        return outputString;
    }

    private final class TextTableEntry {
        private String find;
        private String replace;
        public int findLength = 0;
        public int replaceLength = 0;

        public TextTableEntry(String findString, String replaceString) {
            this.find = findString;
            if (this.find != null) {
                this.findLength = this.find.length();
            }
            this.replace = replaceString;
            if (this.replace != null) {
                this.replaceLength = this.replace.length();
            }
        }

        public String getFind() {
            return this.find;
        }

        public String getReplace() {
            return this.replace;
        }
    }

    public final class EntryComponent {
        private boolean validComponent = true;
        private String name;
        private int numBitsOffset;
        private int bitCount;
        private EntryType type;
        private File associatedList;
        private Target_File.AccessType accessType;

        private int parseVerboseInt(String input) {
            String loadedString = String.format("%s", input);
            boolean negative = false;
            int base = 10;
            int shift = 3;
            int retVal = -1;
            if (input.charAt(0) == '-') {
                negative = true;
                input = input.substring(1);
            }
            if (input.indexOf("0x") == 0) {
                base = 16;
                input = input.substring(2);
            }
            if (input.indexOf("b") == input.length() - 1) {
                shift = 0;
                input = input.substring(0, input.length() - 1);
            }
            try {
                retVal = Integer.parseInt(input, base);
            }
            catch (Exception e) {
                Module.this.addGeneralError(loadedString);
                this.validComponent = false;
            }
            if (this.validComponent) {
                retVal <<= shift;
                if (negative) {
                    retVal = 0 - retVal;
                }
            }
            return retVal;
        }

        public boolean isValid() {
            return this.validComponent;
        }

        public void setName(String input) {
            if (input == null) {
                this.validComponent = false;
            } else {
                this.name = input;
            }
        }

        public void setNumBitsOffset(String input) {
            if (input == null) {
                this.validComponent = false;
            } else {
                this.numBitsOffset = this.parseVerboseInt(input);
            }
            if (this.numBitsOffset < 0) {
                if (!numBitsOffsetErrorDisplayed) {
                    throw new IllegalArgumentException("You can't have negative offsets!");
                }
                numBitsOffsetErrorDisplayed = true;
                this.validComponent = false;
            }
        }

        public void setBitCount(String input) {
            if (input == null) {
                this.validComponent = false;
            } else {
                this.bitCount = this.parseVerboseInt(input);
            }
            if (this.bitCount <= 0) {
                if (!bitCountErrorDisplayed) {
                    throw new IllegalArgumentException("You can't have absent or negative data lengths!");
                }
                bitCountErrorDisplayed = true;
                this.validComponent = false;
            }
        }

        public void setType(String input) {
            if (input == null) {
                this.validComponent = false;
            } else {
                try {
                    this.type = EntryType.valueOf(input);
                }
                catch (Exception e) {
                    Module.this.addGeneralError(input);
                    this.validComponent = false;
                }
            }
            if (!(this.type != EntryType.TEXT && this.type != EntryType.HEXA || this.numBitsOffset % 8 == 0 && this.bitCount % 8 == 0)) {
                if (!arrayTypeErrorDisplayed) {
                    throw new IllegalArgumentException("Array editing components must be byte aligned and\nmust have a length in bytes!");
                }
                arrayTypeErrorDisplayed = true;
                this.validComponent = false;
            }
            if (this.type != EntryType.TEXT && this.type != EntryType.HEXA && this.bitCount > 32) {
                if (!tooManyBitsErrorDisplayed) {
                    throw new IllegalArgumentException("This application does not support bit arrays with\nmore than 32 bits");
                }
                tooManyBitsErrorDisplayed = true;
                this.validComponent = false;
            }
            if (this.type == EntryType.STRUCT && this.getAccessType(0) != Target_File.AccessType.WORD) {
                if (!structErrorDisplayed) {
                    throw new IllegalArgumentException("This application does not support struct pointers\nnot aligned by 32 bits");
                }
                structErrorDisplayed = true;
                this.validComponent = false;
            }
        }

        public void setAssociatedList(String input) {
            if (input == null) {
                this.validComponent = false;
            } else {
                this.associatedList = input.equals("NULL") ? null : new File(input);
            }
        }

        public String getName() {
            return this.name;
        }

        public int getNumBitsOffset() {
            return this.numBitsOffset;
        }

        public int getAddress(int index) {
            return (this.numBitsOffset >> 3) + Module.this.entrySize * index + Module.this.baseAddress;
        }

        public int getBitCount() {
            return this.bitCount;
        }

        private void calculateAccessType(int index) {
            int significand = (this.getAddress(index) << 3) + this.numBitsOffset % 8;
            int bits = this.bitCount;
            Target_File.AccessType supposedType = Target_File.calculateAccessType(significand, true);
            this.accessType = supposedType != Target_File.AccessType.BIT && bits == 8 ? Target_File.AccessType.BYTE : ((supposedType == Target_File.AccessType.HALF || supposedType == Target_File.AccessType.WORD) && bits == 16 ? Target_File.AccessType.HALF : (supposedType == Target_File.AccessType.WORD && bits == 32 ? Target_File.AccessType.WORD : Target_File.AccessType.BIT));
        }

        public Target_File.AccessType getAccessType(int index) {
            if (this.accessType == null) {
                this.calculateAccessType(index);
            }
            return this.accessType;
        }

        public EntryType getEntryType() {
            return this.type;
        }

        public String getAssociatedListPath() {
            return this.associatedList.getPath();
        }
    }

    public static enum EntryType {
        TEXT,
        HEXA,
        NEHU,
        NEDS,
        NEDU,
        NDHU,
        NDDU,
        STRUCT;

    }
}

