/*
 * Decompiled with CFR 0.152.
 */
package Controls;

import java.text.ParseException;
import javax.swing.text.DefaultFormatter;

public class UnsignedNumberFormatter
extends DefaultFormatter {
    private int pivotVal;

    public UnsignedNumberFormatter(int bits) {
        if (bits > 32) {
            throw new IllegalArgumentException("UnsignedNumberFormatter only works with 32 bits or less");
        }
        if (bits <= 0) {
            throw new IllegalArgumentException("UnsignedNumberFormatter can't function without a valid specification of bit length");
        }
        this.pivotVal = 1 << bits;
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        try {
            Object value = this.getFormattedTextField().getValue();
            Long temp = Long.valueOf(string);
            if (temp >= (long)(this.pivotVal >> 1)) {
                temp = temp - (long)this.pivotVal;
            }
            if (value instanceof Byte) {
                return new Integer(temp.byteValue());
            }
            if (value instanceof Short) {
                return new Integer(temp.shortValue());
            }
            if (value instanceof Integer) {
                return new Integer(temp.intValue());
            }
            if (value instanceof Long) {
                return Long.valueOf(string);
            }
            throw new IllegalArgumentException("UnsignedNumberFormatter only works with wrappers of primitive numeric types");
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(string, 0);
        }
    }

    @Override
    public String valueToString(Object value) {
        long valToPrint = ((Number)value).longValue();
        if (valToPrint < 0L) {
            valToPrint += (long)this.pivotVal;
        }
        return Long.toString(valToPrint);
    }
}

