/*
 * Decompiled with CFR 0.152.
 */
package Controls;

import Controls.DependentControl;
import Model.Module;
import Model.Target_File;
import Model.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import nightmare2.StructPane;

public class TextField
extends JTextField
implements DependentControl {
    private StructPane view;
    private Module module;
    private Module.EntryComponent currComponent;

    public TextField(final StructPane view, final Module module, final Module.EntryComponent currComponent) {
        super("Enter text here                    ");
        this.view = view;
        this.module = module;
        this.currComponent = currComponent;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!view.selectionInBounds()) {
                    return;
                }
                String loadedString = TextField.this.getText();
                loadedString = module.encode(Util.condenseCharacterCodes(loadedString));
                int address = currComponent.getAddress(view.getSelectedIndex());
                try {
                    int byteCount = currComponent.getBitCount() >> 3;
                    while (loadedString.length() < byteCount) {
                        loadedString = loadedString + "\u0000";
                    }
                    loadedString = loadedString.substring(0, byteCount);
                    Target_File.putString(Target_File.getData(), address, loadedString);
                }
                catch (Exception e) {
                    // empty catch block
                }
                TextField.this.update();
            }
        });
    }

    @Override
    public void update() {
        int address = this.currComponent.getAddress(this.view.getSelectedIndex());
        try {
            int length = this.currComponent.getBitCount() >> 3;
            String loaded = Target_File.pullString(new byte[length], 0, length);
            if (this.view.selectionInBounds()) {
                loaded = Target_File.pullString(Target_File.getData(), address, address + length);
            }
            this.setText(Util.expandCharacterCodes(this.module.translate(loaded)));
            this.view.update();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

