/*
 * Decompiled with CFR 0.152.
 */
package Controls;

import Controls.DependentControl;
import Controls.HexEditor;
import Model.Module;
import Model.Target_File;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import nightmare2.ModuleFrame;
import nightmare2.StructPane;

public class StructLoader
extends JPanel
implements DependentControl {
    private StructPane view;
    private Module module;
    private Module.EntryComponent currComponent;
    private HexEditor editor;

    public StructLoader(StructPane view, final Module module, final Module.EntryComponent currComponent) {
        this.view = view;
        this.module = module;
        this.currComponent = currComponent;
        this.setLayout(new BorderLayout());
        this.editor = new HexEditor(view, module, currComponent);
        JButton editButton = new JButton("Edit");
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int baseAddress = (Integer)StructLoader.this.editor.getValue();
                if (baseAddress == 0) {
                    return;
                }
                if ((baseAddress -= module.getHardwareOffset()) < 0 || baseAddress >= Target_File.size()) {
                    return;
                }
                ModuleFrame.newStruct(new File(currComponent.getAssociatedListPath()), baseAddress);
            }
        });
        this.add((Component)this.editor, "East");
        this.add((Component)editButton, "West");
    }

    @Override
    public void update() {
        this.editor.update();
    }
}

