/*
 * Decompiled with CFR 0.152.
 */
package Controls;

import Controls.DependentControl;
import Controls.WrappingNumberModel;
import Model.Module;
import Model.Target_File;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nightmare2.StructPane;

public class SignedEditor
extends JSpinner
implements DependentControl {
    private StructPane view;
    private Module module;
    private Module.EntryComponent currComponent;

    public SignedEditor(final StructPane view, Module module, final Module.EntryComponent currComponent) {
        this.view = view;
        this.module = module;
        this.currComponent = currComponent;
        this.setModel();
        this.setEditor();
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (!view.selectionInBounds()) {
                    return;
                }
                int address = currComponent.getAddress(view.getSelectedIndex());
                Target_File.AccessType accessType = currComponent.getAccessType(view.getSelectedIndex());
                try {
                    switch (accessType) {
                        case BYTE: {
                            Target_File.putByte(address, ((Integer)SignedEditor.this.getValue()).byteValue());
                            break;
                        }
                        case HALF: {
                            Target_File.putShort(address, ((Integer)SignedEditor.this.getValue()).shortValue());
                            break;
                        }
                        case WORD: {
                            Target_File.putInt(address, (Integer)SignedEditor.this.getValue());
                            break;
                        }
                        case BIT: {
                            int bitOffset = currComponent.getNumBitsOffset();
                            int bits = currComponent.getBitCount();
                            Target_File.putBits(address, bitOffset % 8, bits, (Integer)SignedEditor.this.getValue());
                            break;
                        }
                    }
                    SignedEditor.this.update();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        });
    }

    protected final Module.EntryComponent getComponent() {
        return this.currComponent;
    }

    protected void setModel() {
        WrappingNumberModel model = new WrappingNumberModel(0, -(1 << this.currComponent.getBitCount() - 1), (1 << this.currComponent.getBitCount() - 1) - 1, 1);
        this.setModel(model);
    }

    protected void setEditor() {
        this.setEditor(new JSpinner.NumberEditor((JSpinner)this, "#"));
    }

    @Override
    public void update() {
        int address = this.currComponent.getAddress(this.view.getSelectedIndex());
        Target_File.AccessType accessType = this.currComponent.getAccessType(this.view.getSelectedIndex());
        try {
            int val = 0;
            if (this.view.selectionInBounds()) {
                switch (accessType) {
                    case BYTE: {
                        val = Target_File.getByte(address);
                        break;
                    }
                    case HALF: {
                        val = Target_File.getShort(address);
                        break;
                    }
                    case WORD: {
                        val = Target_File.getInt(address);
                        break;
                    }
                    case BIT: {
                        int bitOffset = this.currComponent.getNumBitsOffset();
                        int bits = this.currComponent.getBitCount();
                        int pivotVal = 1 << bits;
                        val = Target_File.getBits(address, bitOffset % 8, bits);
                        if (val >= pivotVal >> 1) {
                            val -= pivotVal;
                        }
                        this.setValue(val);
                        break;
                    }
                }
            }
            this.setValue(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

