/*
 * Decompiled with CFR 0.152.
 */
package Controls;

import java.text.ParseException;
import javax.swing.text.DefaultFormatter;

public class HexNumberFormatter
extends DefaultFormatter {
    private int width;

    public HexNumberFormatter(int width) {
        if (width > 16) {
            throw new IllegalArgumentException("HexFormat width > 16");
        }
        this.width = width;
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        try {
            if (string.length() > this.width) {
                throw new ParseException("Max " + this.width + " digits allowed.", 0);
            }
            Object value = this.getFormattedTextField().getValue();
            if (value instanceof Byte) {
                return Long.valueOf(string, 16).byteValue();
            }
            if (value instanceof Short) {
                return Long.valueOf(string, 16).shortValue();
            }
            if (value instanceof Integer) {
                return Long.valueOf(string, 16).intValue();
            }
            if (value instanceof Long) {
                if (string.length() == 16) {
                    String topDigit = string.substring(0, 1);
                    String theRest = string.substring(1);
                    boolean negative = false;
                    int topDigitVal = Integer.valueOf(topDigit, 16);
                    if (topDigitVal > 7) {
                        negative = true;
                        topDigitVal -= 8;
                    }
                    String newS = Integer.toString(topDigitVal, 16);
                    newS = newS + theRest;
                    long out = Long.valueOf(newS, 16);
                    return negative ? -out : out;
                }
                return Long.valueOf(string, 16);
            }
            throw new IllegalArgumentException("HexNumberFormatter only works with wrappers of primitive numeric types");
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(string, 0);
        }
    }

    @Override
    public String valueToString(Object value) {
        long asLong = ((Number)value).longValue();
        String valString = Long.toHexString(asLong);
        int leadingZeroes = this.width - valString.length();
        return (leadingZeroes <= 0 ? valString.substring(valString.length() - this.width) : "0000000000000000".substring(0, leadingZeroes) + valString).toUpperCase();
    }
}

