/*
 * Decompiled with CFR 0.152.
 */
package Controls;

import Controls.DependentControl;
import Model.Module;
import Model.Target_File;
import Model.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JTextField;
import nightmare2.StructPane;

public class HexField
extends JTextField
implements DependentControl {
    private StructPane view;
    private Module module;
    private Module.EntryComponent currComponent;

    public HexField(final StructPane view, Module module, final Module.EntryComponent currComponent) {
        super("Enter hex info here                ");
        this.view = view;
        this.module = module;
        this.currComponent = currComponent;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!view.selectionInBounds()) {
                    return;
                }
                String loadedString = HexField.this.getText();
                byte[] input = Util.stringToByteArray(loadedString, currComponent.getBitCount() >> 3);
                int address = currComponent.getAddress(view.getSelectedIndex());
                try {
                    if (input == null) {
                        HexField.this.setText(Util.byteArrayToString(Arrays.copyOfRange(Target_File.getData(), address, address + (currComponent.getBitCount() >> 3))));
                    } else {
                        Target_File.overwriteFile(input, address);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                HexField.this.update();
            }
        });
    }

    @Override
    public void update() {
        int address = this.currComponent.getAddress(this.view.getSelectedIndex());
        try {
            byte[] loaded = new byte[this.currComponent.getBitCount() >> 3];
            if (this.view.selectionInBounds()) {
                loaded = Arrays.copyOfRange(Target_File.getData(), address, address + loaded.length);
            }
            this.setText(Util.byteArrayToString(loaded));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

