/*
 * Decompiled with CFR 0.152.
 */
package Controls;

import Controls.DependentControl;
import Model.Module;
import Model.Target_File;
import Model.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import java.util.Scanner;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import nightmare2.StructPane;

public class DecimalList
extends JComboBox
implements DependentControl {
    private StructPane view;
    private Module module;
    private Module.EntryComponent currComponent;

    public DecimalList(final StructPane view, Module module, final Module.EntryComponent currComponent) {
        this.view = view;
        this.module = module;
        this.currComponent = currComponent;
        LinkedList<String> loadedStringsList = new LinkedList<String>();
        Scanner listScanner = null;
        try {
            listScanner = new Scanner(new File(currComponent.getAssociatedListPath()));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (listScanner != null) {
            try {
                listScanner.nextLine();
            }
            catch (Exception e) {
                // empty catch block
            }
            String tempString = null;
            Target_File.AccessType accessType = currComponent.getAccessType(view.getSelectedIndex());
            while (listScanner.hasNext()) {
                String loadedString;
                try {
                    loadedString = listScanner.nextLine();
                }
                catch (Exception e) {
                    break;
                }
                Long asLong = null;
                try {
                    tempString = loadedString.substring(2, loadedString.indexOf(" "));
                    asLong = Long.parseLong(tempString, 16);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (asLong == null) continue;
                loadedStringsList.add(this.formatString(asLong, accessType) + loadedString.substring(loadedString.indexOf(" ")));
            }
            try {
                listScanner.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String[] loadedStrings = new String[loadedStringsList.size()];
        int i = 0;
        for (String currString : loadedStringsList) {
            loadedStrings[i++] = currString;
        }
        this.setModel(new DefaultComboBoxModel<String>(loadedStrings));
        this.setEditable(true);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String loadedString;
                if (!view.selectionInBounds()) {
                    return;
                }
                int address = currComponent.getAddress(view.getSelectedIndex());
                Target_File.AccessType accessType = currComponent.getAccessType(view.getSelectedIndex());
                boolean valid = true;
                if (DecimalList.this.getSelectedItem() == null) {
                    valid = false;
                }
                if ((loadedString = (String)DecimalList.this.getSelectedItem()).length() == 0) {
                    valid = false;
                }
                int numberOffset = DecimalList.this.leadingDigits();
                int base = DecimalList.this.base();
                int spaceIndex = loadedString.indexOf(" ");
                if (spaceIndex == -1) {
                    spaceIndex = loadedString.length();
                }
                Long asLong = null;
                try {
                    asLong = Long.parseLong(loadedString.substring(numberOffset, spaceIndex), base);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (!valid || asLong == null) {
                        throw new RuntimeException("Failed to load");
                    }
                    switch (accessType) {
                        case BYTE: {
                            Target_File.putByte(address, asLong.byteValue());
                            break;
                        }
                        case HALF: {
                            Target_File.putShort(address, asLong.shortValue());
                            break;
                        }
                        case WORD: {
                            Target_File.putInt(address, asLong.intValue());
                            break;
                        }
                        case BIT: {
                            int bitOffset = currComponent.getNumBitsOffset();
                            int bits = currComponent.getBitCount();
                            Target_File.putBits(address, bitOffset % 8, bits, asLong.intValue());
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                DecimalList.this.update();
            }
        });
    }

    protected int leadingDigits() {
        return 0;
    }

    protected int base() {
        return 10;
    }

    protected String formatString(Long asLong, Target_File.AccessType accessType) {
        return "" + asLong;
    }

    @Override
    public void update() {
        int address = this.currComponent.getAddress(this.view.getSelectedIndex());
        Target_File.AccessType accessType = this.currComponent.getAccessType(this.view.getSelectedIndex());
        try {
            String validString = "";
            Long asLong = null;
            if (this.view.selectionInBounds()) {
                switch (accessType) {
                    case BYTE: {
                        asLong = Target_File.getByte(address) & 0xFF;
                        break;
                    }
                    case HALF: {
                        asLong = Target_File.getShort(address) & 0xFFFF;
                        break;
                    }
                    case WORD: {
                        asLong = Target_File.getInt(address) & 0xFFFFFFFF;
                        break;
                    }
                    case BIT: {
                        int bitOffset = this.currComponent.getNumBitsOffset();
                        int bits = this.currComponent.getBitCount();
                        long val = Target_File.getBits(address, bitOffset % 8, bits);
                        asLong = val & Util.mask(bits);
                        break;
                    }
                }
            } else {
                asLong = 0L;
            }
            validString = this.formatString(asLong, accessType);
            boolean found = false;
            for (int i = 0; i < this.getItemCount(); ++i) {
                if (((String)this.getItemAt(i)).indexOf(validString) != 0) continue;
                validString = (String)this.getItemAt(i);
                found = true;
                break;
            }
            if (!found) {
                validString = validString + String.format(" Default value for entry 0x%X", this.view.getSelectedIndex());
            }
            this.setSelectedItem(validString);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

