/*
 * Decompiled with CFR 0.152.
 */
package Compression_Interface;

import Model.Util;
import java.util.Arrays;
import java.util.Vector;

public class Lempel_Ziv {
    public static final int BLOCK_SIZE = 8;
    public static final int READ_AHEAD_BUFFER_SIZE = 18;
    public static final int SLIDING_WINDOW_SIZE = 4096;

    private static byte[] decompressionHelper(byte[] input) {
        if (input != null && input[0] != 16) {
            return null;
        }
        int size = Util.bytesToInts(new byte[][]{Arrays.copyOf(input, 4)})[0] >> 8 & 0xFFFFFF;
        int writeAddress = 0;
        int index = 4;
        byte[] output = new byte[size];
        int blockCount = 0;
        int isCompressed = 0;
        while (writeAddress < output.length) {
            isCompressed = blockCount == 0 ? input[index++] : (isCompressed <<= 1);
            blockCount = (blockCount + 1) % 8;
            if ((isCompressed & 0x80) == 0) {
                byte tempByte = 0;
                tempByte = input[index++];
                output[writeAddress++] = tempByte;
                continue;
            }
            int first = 0;
            first = input[index++] & 0xFF;
            int amountToCopy = 3 + (first >> 4);
            byte tempByte = 0;
            tempByte = input[index++];
            int copyOffset = (first & 0xF) << 8 | tempByte & 0xFF;
            int i = 0;
            while (i < amountToCopy) {
                output[writeAddress] = output[writeAddress - copyOffset - 1];
                ++i;
                ++writeAddress;
            }
        }
        return output;
    }

    public static byte[] decompress(byte[] input) {
        return Lempel_Ziv.decompressionHelper(input);
    }

    public static int[] search(byte[] input, int position, int length) {
        Vector<Integer> results = new Vector<Integer>();
        if (position >= length) {
            return new int[]{-1, 0};
        }
        if (position < 3 || length - position < 3) {
            return new int[]{0, 0};
        }
        for (int i = 1; i < 4096 && i < position; ++i) {
            if (input[position - i - 1] != input[position]) continue;
            results.add(i + 1);
        }
        if (results.size() == 0) {
            return new int[]{0, 0};
        }
        int amountOfBytes = 0;
        while (amountOfBytes < 18) {
            ++amountOfBytes;
            boolean searchComplete = false;
            for (int i = results.size() - 1; i >= 0; --i) {
                try {
                    if (input[position + amountOfBytes] == input[position - (Integer)results.get(i) + amountOfBytes % (Integer)results.get(i)]) continue;
                    if (results.size() > 1) {
                        results.removeElementAt(i);
                        continue;
                    }
                    searchComplete = true;
                    continue;
                }
                catch (Exception error) {
                    return new int[]{0, 0};
                }
            }
            if (!searchComplete) continue;
            break;
        }
        return new int[]{amountOfBytes, (Integer)results.get(0)};
    }

    public static byte[] compress(byte[] input) {
        int i;
        int length = input.length;
        int position = 0;
        byte[] output = null;
        Vector<Byte> compressedData = new Vector<Byte>();
        compressedData.add((byte)16);
        compressedData.add((byte)length);
        compressedData.add((byte)(length >> 8));
        compressedData.add((byte)(length >> 16));
        byte isCompressed = 0;
        int[] searchResult = null;
        Byte add = 0;
        Vector<Byte> tempVector = null;
        while (position < length) {
            isCompressed = 0;
            tempVector = new Vector<Byte>();
            for (i = 0; i < 8; ++i) {
                searchResult = Lempel_Ziv.search(input, position, length);
                if (searchResult[0] > 2) {
                    add = (byte)(((searchResult[0] - 3 & 0xF) << 4) + (searchResult[1] - 1 >> 8 & 0xF));
                    tempVector.add(add);
                    add = (byte)(searchResult[1] - 1 & 0xFF);
                    tempVector.add(add);
                    position += searchResult[0];
                    isCompressed = (byte)(isCompressed | (byte)(1 << 8 - (i + 1)));
                    continue;
                }
                if (searchResult[0] < 0) break;
                tempVector.add(input[position++]);
            }
            compressedData.add(isCompressed);
            compressedData.addAll(tempVector);
        }
        while (compressedData.size() % 4 != 0) {
            compressedData.add((byte)0);
        }
        output = new byte[compressedData.size()];
        i = 0;
        for (Byte curr : compressedData) {
            output[i++] = curr;
        }
        return output;
    }
}

